/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.IAmmoMaterial;
import dev.toma.gunsrpg.api.common.IReloadManager;
import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.api.common.data.IJamInfo;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.data.IReloadInfo;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.api.common.skill.IClickableSkill;
import dev.toma.gunsrpg.api.common.skill.ISkill;
import dev.toma.gunsrpg.client.animation.ModAnimations;
import dev.toma.gunsrpg.client.screen.ChooseAmmoScreen;
import dev.toma.gunsrpg.client.screen.skill.SkillTreeScreen;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.init.ModItems;
import dev.toma.gunsrpg.common.init.ModRegistries;
import dev.toma.gunsrpg.common.item.StashDetectorItem;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import dev.toma.gunsrpg.common.item.guns.ammo.AmmoType;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.network.NetworkManager;
import dev.toma.gunsrpg.network.packet.C2S_ChangeFiremodePacket;
import dev.toma.gunsrpg.network.packet.C2S_PacketSetJamming;
import dev.toma.gunsrpg.network.packet.C2S_RequestBatteryChange;
import dev.toma.gunsrpg.network.packet.C2S_RequestDataUpdatePacket;
import dev.toma.gunsrpg.network.packet.C2S_SetReloadingPacket;
import dev.toma.gunsrpg.network.packet.C2S_SkillClickedPacket;
import dev.toma.gunsrpg.util.SkillUtil;
import dev.toma.gunsrpg.util.locate.ILocatorPredicate;
import dev.toma.gunsrpg.util.locate.ammo.ItemLocator;
import dev.toma.gunsrpg.util.object.ShootingManager;
import java.util.ArrayList;
import java.util.List;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.AnimationUtils;
import lib.toma.animations.api.Animation;
import lib.toma.animations.api.IAnimationPipeline;
import lib.toma.animations.api.IKeyframeProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class ModKeybinds {
    private static final List<ModKeyBind> keyBinds = new ArrayList<ModKeyBind>(2);

    public static void registerKeybinds() {
        ModKeybinds.register("unjam", 88, ModKeybinds::unjamPressed);
        ModKeybinds.register("reload", 82, ModKeybinds::reloadPressed);
        ModKeybinds.register("class_list", 79, ModKeybinds::showClassesPressed);
        ModKeybinds.register("firemode", 66, () -> {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player.func_184614_ca().func_77973_b() instanceof GunItem) {
                NetworkManager.sendServerPacket(new C2S_ChangeFiremodePacket());
            }
        });
        ModKeybinds.register("skill.slot.1", 321, () -> ModKeybinds.activateSkillSlot(0));
        ModKeybinds.register("skill.slot.2", 322, () -> ModKeybinds.activateSkillSlot(1));
        ModKeybinds.register("skill.slot.3", 323, () -> ModKeybinds.activateSkillSlot(2));
        ModKeybinds.register("skill.slot.4", 324, () -> ModKeybinds.activateSkillSlot(3));
        ModKeybinds.register("skill.slot.5", 325, () -> ModKeybinds.activateSkillSlot(4));
    }

    public static <S extends ISkill & IClickableSkill, T extends SkillType<S>> void activateSkillSlot(int slotNumber) {
        String[] boundSkills = GunsRPG.config.skills.boundSkills;
        if (slotNumber >= boundSkills.length) {
            GunsRPG.log.warn("Bind skill activation failed: Undefined skill slot {}", (Object)(slotNumber + 1));
            return;
        }
        ResourceLocation skillId = new ResourceLocation(boundSkills[slotNumber]);
        SkillType skillType = (SkillType)ModRegistries.SKILLS.getValue(skillId);
        if (skillType == null) {
            GunsRPG.log.warn("Bind skill activation failed: Unknown skill {}", (Object)skillId);
            return;
        }
        if (skillType.isDisabled()) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        PlayerData.get((PlayerEntity)player).ifPresent(data -> {
            ISkillProvider provider = data.getSkillProvider();
            Object skill = SkillUtil.getTopHierarchySkill(skillType, provider);
            if (skill == null) {
                GunsRPG.log.warn("Bind skill activation failed: Skill is locked {}", (Object)skillId);
                return;
            }
            ResourceLocation actualId = skill.getType().getRegistryName();
            if (!(skill instanceof IClickableSkill)) {
                GunsRPG.log.warn("Bind skill activation failed: Skill cannot be activated {}", (Object)actualId);
                return;
            }
            IClickableSkill clickableSkill = (IClickableSkill)skill;
            if (!clickableSkill.canUse()) {
                GunsRPG.log.warn("Bind skill activation failed: Skill cannot be used in current conditions {}", (Object)actualId);
                return;
            }
            SkillType<?> type = skill.getType();
            NetworkManager.sendServerPacket(new C2S_SkillClickedPacket(type));
        });
    }

    private static void unjamPressed() {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        IPlayerData data = PlayerData.getUnsafe((PlayerEntity)player);
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof GunItem) {
            IJamInfo info = data.getJamInfo();
            GunItem gunItem = (GunItem)stack.func_77973_b();
            if (gunItem.isJammed(stack) && !info.isUnjamming()) {
                int slot = player.field_71071_by.field_70461_c;
                int time = gunItem.getUnjamTime(stack, data.getAttributes());
                ResourceLocation animationPath = gunItem.getUnjamAnimationPath();
                info.startUnjamming(player.field_71071_by.field_70461_c, time);
                NetworkManager.sendServerPacket(new C2S_PacketSetJamming(true, time, slot));
                AnimationEngine.get().pipeline().insert(ModAnimations.UNJAM, AnimationUtils.createAnimation(animationPath, provider -> new Animation((IKeyframeProvider)provider, time)));
            }
        }
    }

    private static void reloadPressed() {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        IPlayerData data = PlayerData.getUnsafe((PlayerEntity)player);
        IReloadInfo info = data.getReloadInfo();
        IJamInfo jamInfo = data.getJamInfo();
        ItemStack stack = player.func_184614_ca();
        if (player.func_213453_ef()) {
            if (stack.func_77973_b() instanceof GunItem) {
                mc.func_147108_a((Screen)new ChooseAmmoScreen((GunItem)stack.func_77973_b()));
            }
        } else {
            if (jamInfo.isUnjamming()) {
                return;
            }
            AnimationEngine engine = AnimationEngine.get();
            IAnimationPipeline pipeline = engine.pipeline();
            IAttributeProvider attributeProvider = data.getAttributes();
            if (stack.func_77973_b() instanceof GunItem && ShootingManager.isShootingReady()) {
                IReloadManager manager;
                GunItem gun = (GunItem)stack.func_77973_b();
                if (gun.isJammed(stack)) {
                    return;
                }
                if (info.isReloading() && (manager = gun.getReloadManager((PlayerEntity)player, data.getAttributes())).isCancelable()) {
                    info.enqueueCancel();
                    NetworkManager.sendServerPacket(new C2S_SetReloadingPacket(false, 0));
                    return;
                }
                AmmoType ammoType = gun.getAmmoType();
                IAmmoMaterial material = gun.getMaterialFromNBT(stack);
                if (material != null) {
                    int ammo = gun.getAmmo(stack);
                    int max = gun.getMaxAmmo(data.getAttributes());
                    boolean skip = player.func_184812_l_();
                    boolean reloading = info.isReloading();
                    if (!reloading && ammo < max) {
                        if (skip) {
                            info.startReloading((PlayerEntity)player, gun, stack, player.field_71071_by.field_70461_c);
                            NetworkManager.sendServerPacket(new C2S_SetReloadingPacket(true, gun.getReloadTime(data.getAttributes(), stack)));
                            return;
                        }
                        PlayerInventory inventory = player.field_71071_by;
                        ILocatorPredicate<ItemStack> typeCheck = ItemLocator.filterByAmmoTypeAndMaterial(ammoType, material);
                        if (ItemLocator.contains((IInventory)inventory, typeCheck)) {
                            int reloadTime = gun.getReloadTime(attributeProvider, stack);
                            info.startReloading((PlayerEntity)player, gun, stack, inventory.field_70461_c);
                            NetworkManager.sendServerPacket(new C2S_SetReloadingPacket(true, reloadTime));
                        }
                    }
                } else {
                    mc.func_147108_a((Screen)new ChooseAmmoScreen(gun));
                }
            } else if (stack.func_77973_b() == ModItems.STASH_DETECTOR) {
                ItemStack batteryItem = ItemLocator.findFirst((IInventory)player.field_71071_by, StashDetectorItem::isValidBatterySource);
                if (stack.func_77952_i() > 0 && !batteryItem.func_190926_b()) {
                    pipeline.insert(ModAnimations.STASH_DETECTOR, AnimationUtils.createAnimation(StashDetectorItem.CHARGE_BATTERY_ANIMATION, provider -> new Animation((IKeyframeProvider)provider, 120)));
                    NetworkManager.sendServerPacket(new C2S_RequestBatteryChange());
                }
            }
        }
    }

    private static void showClassesPressed() {
        Minecraft mc = Minecraft.func_71410_x();
        NetworkManager.sendServerPacket(new C2S_RequestDataUpdatePacket(mc.field_71439_g.func_110124_au()));
        mc.func_147108_a((Screen)new SkillTreeScreen());
    }

    private static void register(String name, int key, Runnable onPress) {
        ModKeyBind bind = new ModKeyBind(String.format("gunsrpg.key.%s", name), key, "gunsrpg.category.keys", onPress);
        ClientRegistry.registerKeyBinding((KeyBinding)bind);
        keyBinds.add(bind);
    }

    @SubscribeEvent
    public void onInput(InputEvent.KeyInputEvent event) {
        for (ModKeyBind bind : keyBinds) {
            if (!bind.func_151470_d()) continue;
            bind.onPress.run();
            break;
        }
    }

    private static class ModKeyBind
    extends KeyBinding {
        private final Runnable onPress;

        private ModKeyBind(String name, int key, String category, Runnable onPress) {
            super(name, key, category);
            this.onPress = onPress;
        }
    }
}

